local t = LoadFallbackB();

local function GetDifListY(d)
	local r=0;
	if d == "Difficulty_Beginner" then
		r=(49*0);
	elseif d == "Difficulty_Easy" then
		r=(49*1);
	elseif d == "Difficulty_Medium" then
		r=(49*2);
	elseif d == "Difficulty_Hard" then
		r=(49*3);
	elseif d == "Difficulty_Challenge" then
		r=(49*4);
	elseif d == "Difficulty_Edit" then
		r=(49*5);
	end;
	return r;
end;

local function GetFlexDifListY(d, st, song)
	local r=0;
	local b=0;
	if d == "Difficulty_Beginner" then
		r=(49*0);
	elseif d == "Difficulty_Easy" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		r=(49*b);
	elseif d == "Difficulty_Medium" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		r=(49*b);
	elseif d == "Difficulty_Hard" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Medium") then
			b=b+1;
		end;
		r=(49*b);
	elseif d == "Difficulty_Challenge" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Medium") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Hard") then
			b=b+1;
		end;
		r=(49*b);
	elseif d == "Difficulty_Edit" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Medium") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Hard") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Challenge") then
			b=b+1;
		end;
		r=(49*b);
	end;
	return r;
end;


local function GetDifListX(self,pn,offset,fade)
	if pn==PLAYER_1 then
		self:x(SCREEN_CENTER_X-70-offset);
		if fade>0 then
			self:faderight(fade);
		end;
	else
		self:x(SCREEN_CENTER_X+157+offset);
		if fade>0 then
			self:fadeleft(fade);
		end;
	end;
	return r;
end;

local function GetDifListGradeX(self,pn,offset,fade)
	if pn==PLAYER_1 then
		self:x(SCREEN_CENTER_X-395+offset);
		if fade>0 then
			self:faderight(fade);
		end;
	else
		self:x(SCREEN_CENTER_X+101+offset);
		if fade>0 then
			self:fadeleft(fade);
		end;
	end;
	return r;
end;


local function DrawDifList(pn,diff)
	local t=Def.ActorFrame {
		InitCommand=cmd(player,pn;y,SCREEN_CENTER_Y-150-44.5;draworder,55);
--number
		LoadFont("Common Normal")..{
			InitCommand=cmd(zoom,0.5;draworder,2);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
				local course = GAMESTATE:GetCurrentCourse();
			if song then
				GetDifListX(self,pn,135,0);
				self:y(GetFlexDifListY(diff, st, song));
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );
					if PROFILEMAN:IsPersistentProfile(pn) then
						profile = PROFILEMAN:GetProfile(pn);
					else
						profile = PROFILEMAN:GetMachineProfile();
					end;
					scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topscore=0;
					if scores[1] then
						topscore = scores[1]:GetScore();
					end;
					assert(topscore);
					self:diffuse(color("1,1,1,1"));
					self:strokecolor(color("0.2,0.2,0.2,1"));
					self:diffusealpha(1);
					self:shadowlength(2);
					if pn==PLAYER_1 and topscore ~= 0  then
						local scorel3 = topscore%1000;
						local scorel2 = (topscore/1000)%1000;
						local scorel1 = (topscore/1000000)%1000000;
						self:settextf("%01d"..",".."%03d"..",".."%03d",scorel1,scorel2,scorel3);
					elseif pn==PLAYER_2 and topscore ~= 0  then
						local scorel3 = topscore%1000;
						local scorel2 = (topscore/1000)%1000;
						local scorel1 = (topscore/1000000)%1000000;
						self:settextf("%01d"..",".."%03d"..",".."%03d",scorel1,scorel2,scorel3);
					else 
						self:settextf("");
					end;

				else
					self:settext("");
				end;
			end;
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
--grade
		Def.Quad{
			InitCommand=cmd(zoom,0.25);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
				local course = GAMESTATE:GetCurrentCourse();
			if song then
				GetDifListX(self,pn,135,0);
				self:y(GetFlexDifListY(diff, st, song)-19);
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );
					if PROFILEMAN:IsPersistentProfile(pn) then
						profile = PROFILEMAN:GetProfile(pn);
					else
						profile = PROFILEMAN:GetMachineProfile();
					end;
					scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topscore=0;
					if scores[1] then
						topscore = scores[1]:GetScore();
					end;
					assert(topscore);
					local topgrade;
					if scores[1] then
						topgrade = scores[1]:GetGrade();
						assert(topgrade);
						if scores[1]:GetScore()>1  then
							if scores[1]:GetScore()==1000000 and topgrade=="Grade_Tier07" then
								self:LoadBackground(THEME:GetPathG("myMusicWheel","Tier01"));
								self:diffusealpha(1);
								self:addx(22);
							else
								self:LoadBackground(THEME:GetPathG("myMusicWheel",ToEnumShortString(topgrade)));
								self:diffusealpha(1);
								self:addx(22);
							end;	
						else
							self:diffusealpha(0);
						end;
					else
						self:diffusealpha(0);
					end;
				else
					self:diffusealpha(0);
				end;
			else
				self:diffusealpha(0);
			end;
		end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
--FC Ring
		LoadActor(THEME:GetPathG("Player","Badge FullCombo"))..{
			InitCommand=cmd(shadowlength,1;zoom,0;draworder,1);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
				local course = GAMESTATE:GetCurrentCourse();
			if song then
				GetDifListX(self,pn,135,0);
				self:y(GetFlexDifListY(diff, st, song)-19);
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );
					if PROFILEMAN:IsPersistentProfile(pn) then
						profile = PROFILEMAN:GetProfile(pn);
					else
						profile = PROFILEMAN:GetMachineProfile();
					end;
					scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topscore;
					if scores[1] then
						topscore = scores[1];
						assert(topscore);
						local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
						local boos = topscore:GetTapNoteScore("TapNoteScore_W5")
						local goods = topscore:GetTapNoteScore("TapNoteScore_W4")
						local greats = topscore:GetTapNoteScore("TapNoteScore_W3")
						local perfects = topscore:GetTapNoteScore("TapNoteScore_W2")
						local marvelous = topscore:GetTapNoteScore("TapNoteScore_W1")
						self:addx(-31);
						self:addy(13.5);
						if (misses+boos) == 0 and scores[1]:GetScore() > 0 and (marvelous+perfects)>0 then
							if (greats+perfects) == 0 then
								self:diffuse(GameColor.Judgment["JudgmentLine_W1"]);
								self:glowblink();
								self:effectperiod(0.20);
								self:zoom(0.25);
							elseif greats == 0 then
								self:diffuse(GameColor.Judgment["JudgmentLine_W2"]);
								self:glowshift();
								self:zoom(0.25);
							elseif (misses+boos+goods) == 0 then
								self:diffuse(GameColor.Judgment["JudgmentLine_W3"]);
								self:stopeffect();
								self:zoom(0.25);
							elseif (misses+boos) == 0 then
								self:diffuse(GameColor.Judgment["JudgmentLine_W4"]);
								self:stopeffect();
								self:zoom(0.25);
							end;
							self:diffusealpha(0.8);
						else 
							self:diffusealpha(0);
						end;
					else
						self:diffusealpha(0);
					end;
				else
					self:diffusealpha(0);
				end;
			end;
		end;
			CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
		};
	};
	return t;
end;


if  not GAMESTATE:IsCourseMode() then

	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Beginner');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Easy');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Medium');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Hard');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Challenge');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Edit');

	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Beginner');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Easy');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Medium');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Hard');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Challenge');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Edit');

end;

return t;
